-- USE DB_INDEX

-- Rcupration des donnes de statistiques de rgle avant lancement de la requte
SELECT *
INTO   #T1
FROM   sys.dm_exec_query_transformation_stats;
-- Texte de la requte  tester
SELECT * FROM T_EMPLOYEE_EMP WHERE EMP_NOM LIKE 'PO%'
OPTION (RECOMPILE);
-- Rcupration des donnes de statistiques de rgle aprs lancement de la requte
SELECT *
INTO   #T2
FROM   sys.dm_exec_query_transformation_stats;

--> NOTA : nous avons chang la requte afin de la faire fonctionner sur la base DB_INDEX

WITH T AS
(
SELECT T2.name,
       T2.promise_total - T1.promise_total AS promise_total,
       T2.promise_avg - T1.promise_avg AS promise_avg,
       T2.promised - T1.promised AS promised,
       T2.built_substitute - T1.built_substitute AS built_substitute,
       T2.succeeded - T1.succeeded AS succeeded
FROM   #T2 AS T2
       INNER JOIN #T1 AS T1
             ON T1.name = T2.name
UNION ALL
SELECT T2.name,
       T2.promise_total,
       T2.promise_avg,
       T2.promised,
       T2.built_substitute,
       T2.succeeded
FROM   #T2 AS T2
       LEFT OUTER JOIN #T1 AS T1
            ON T1.name = T2.name
WHERE T1.name IS NULL
)
SELECT *
FROM   T
WHERE  promise_total + promise_avg + promised + built_substitute + succeeded > 0 ORDER BY name;

--> NOTA : nous avons rajout la clause OPTION (RECOMPLIE) dans la requte test par rapport  la version imprime. Sans cela il est trs probable que le rsultat sera vide.
